<?php
$abspath = preg_replace('/\\\/', '/', dirname(__FILE__));
if (!file_exists($abspath . '/configs/config.php')) {
    define('PF_VERSION','1.0');
    require $abspath . '/includes/functions.php';
    redirect_to_install($abspath);
}
require $abspath . '/configs/config.php';
session_name('PageFlex' .sha1(__SECURITY_SALT__ . __SECURITY_CIPHER_SEED__));
@session_start();
require ABSPATH . '/includes/helper/url-helper.php';
require ABSPATH . '/includes/error-handler-class.php';
require ABSPATH . '/includes/pf-class.php';
require ABSPATH . '/admin/includes/option.php';
require ABSPATH . '/includes/functions.php';
require ABSPATH . '/admin/plugins/user/class/authentication/auth.php';
require ABSPATH . '/admin/plugins/user/class/pf-user.php';
require ABSPATH . '/includes/plugin-class.php';
require ABSPATH . '/includes/widget-class.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext/MO.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext/PO.php';
require ABSPATH . '/includes/helper/l10n-helper.php';
require ABSPATH . '/includes/helper/form-helper.php';
require_once ABSPATH . '/includes/paginator-class.php';
require ABSPATH . '/admin/includes/functions.php';
require ABSPATH . '/includes/common/libs/image/simple_image.php';
global $pattern_templates;
global $_public_css;

public_css('css/bootstrap.min.css');
public_css('css/color-styles.css');
public_css('css/ui-elements.css');
public_css('css/custom.css');
public_css('css/animate.css'); 
public_css('fonts/font-awesome/css/font-awesome.min.css');

global $_public_js;
public_js('js/scrolltopcontrol.js');
public_js('js/bootstrap-hover-dropdown.min.js');
public_js('js/menu-widgets.js');
public_js('js/custom.js');
if (is_null(Pf::auth()->get_session("user-id"))&&Pf::auth()->check_cookie("id")){
    set_session(Pf::auth()->get_cookie("id"));
}

/**
 * Configuration
 */
$setting = Pf::setting();
define('DEFAULT_LOCALE', get_configuration('site_language'));
define('NUM_PER_PAGE', get_configuration('items_per_page'));
date_default_timezone_set(get_configuration('time_zone'));
if (get_configuration('enable_log') == 1) {
    new Pf_Error_Handler();
}
/*
 * lang
*/
global $locale;
$locale = (!empty($_GET ['lang'])) ? $_GET ['lang'] : DEFAULT_LOCALE;
$_SESSION['lang'] = $locale;
load_includes_language();
/*
 * Charset
 * */
$charset = get_configuration('charset_html');
$exception = false;
//Check site offline
if (get_configuration('site_offline')) {
    $url = get_configuration('site_offline_page');
    $reqUrl = $url;
    $exception = 'pf-default-site-offline';
} else {
    // Get page url.
    $reqUrl = $_SERVER ['REQUEST_URI'];
    if (strpos($reqUrl, '/index.php') !== false) {
        $reqUrl = substr($reqUrl, strlen(RELATIVE_PATH . '/index.php/'), strlen($reqUrl) + 1);
    } else {
        $reqUrl = substr($reqUrl, strlen(RELATIVE_PATH . '/'), strlen($reqUrl));
    }
    
    if(strpos($reqUrl, '?') !== false){
        $reqUrl = explode('?', $reqUrl);
        $reqUrl = $reqUrl[0];
    }

    $reqUrl = trim($reqUrl);
    if (empty($reqUrl)) {
        // Set default page.
        $page_default = get_configuration('default_page');
        if (trim($page_default) != '') {
            $reqUrl = $page_default;
        }
        $exception = 'pf-default-homepage';
    }
    $reqs = explode('/', $reqUrl);
    $reqUrl = $_GET['pf_page_url'] = $reqs[0];

    if (count($reqs) > 0) {
        foreach ($reqs as $v) {
            if (trim($v) != '') {
                $rs = explode(':', $v);
                if (count($rs) == 2) {
                    $_GET[$rs[0]] = $rs[1];
                    if (!empty($_REQUEST[$rs[0]])) {
                        $_REQUEST[$rs[0]] = $_GET[$rs[0]];
                    }
                }
            }
        }
    }
}

// get page
$db = Pf::database();

$db->select('*', 'pf_pages', 'page_url = ? and page_status = 1', array(
    $reqUrl
        ), '', 1);
$rs = $db->fetch_assoc();

// Page not found. Get page error
if (empty($rs)) {
    if($exception !== false){
        $db->select('*', 'pf_pages', 'page_url = ? and page_status = 1', array(
            $exception
        ), '', 1);
        $rs = $db->fetch_assoc();
    }
    if (empty($rs)) {
        $db->select('*', 'pf_pages', 'page_url = ? and page_status = 1', array(
            get_configuration('error_page')
        ), '', 1);
        $rs = $db->fetch_assoc();
        $exception = 'pf-default-error';
    }
    if (empty($rs)) {
        $db->select('*', 'pf_pages', 'page_url = ? and page_status = 1', array(
            $exception
        ), '', 1);
        $rs = $db->fetch_assoc();
    }
}
if (!empty($rs)) {
    // Set info head (Title, Keyword, Description)
    $head_info = array(
        'title' => (!empty($rs['page_meta_title']) ? $rs['page_meta_title'] . ' | ' : '') . get_configuration('site_name'),
        'keywords' => !empty($rs['page_meta_keywords']) ? $rs['page_meta_keywords'] : get_configuration('site_meta_keywords'),
        'description' => !empty($rs['page_meta_description']) ? $rs['page_meta_description'] : get_configuration('site_meta_description'),
        'charset'=>empty($charset) ? "utf-8" : $charset
    );
    set_head_info($head_info);

    load_admin_plugins(ADMIN_PLUGIN_PATH, 'public_init');
    load_active_plugins('public_init');
    if (is_ajax()) {
        $tags = Pf::shortcode()->get_tags();
        foreach ($tags as $ns => $tag) {
            if (!empty($_GET[$ns . '_code'])) {
                die(call_user_func($tag[$_GET[$ns . '_code']], $_REQUEST, null, $_GET[$ns . '_code']));
            }
        }
    }
    // get layout
    $layout = array();
    $layouts = get_option('layouts');
    foreach ($layouts as $v) {
        if ($v['id'] == $rs['page_layout']) {
            $layout = $v;
            break;
        }
    }
    $widgets = array();
    if (!empty($layout['json_data'])) {
        $widgets = json_decode($layout['json_data'], true);
        $active_widgets = get_option('active_widgets');
    }
    $setting_data = array();
    if (!empty($layout['setting_data'])) {
        $setting_data = $layout['setting_data'];
    }
    // get footer
    $footer = get_option('footer');
    $widgets_footer = array();
    if(!empty($footer['json_data'])){
        $widgets_footer = json_decode($footer['json_data'], true);
    }
    $setting_footer = array();
    if(!empty($footer['setting_data'])){
        $setting_footer = $footer['setting_data'];
    }
    
    // Check layout
    if (!empty($layout)) {
        // Get active theme
        $theme = get_option('active_theme');
        // Check theme
        if (is_file(ABSPATH . '/themes/' . $theme . '/' . $theme . '.php')) {
            load_theme_language($theme.'-theme','',$theme);
            require ABSPATH . '/themes/' . $theme . '/' . $theme . '.php';
            // get pattern template
            if (is_file(ABSPATH . '/themes/' . $theme . '/index.php')) {
                ob_start();
                require ABSPATH . '/themes/' . $theme . '/index.php';
                $html = ob_get_contents();
                ob_get_clean();
                // Execute shortcode
                $html = Pf::shortcode()->exec($html);
                
                echo load_css_js($html,$theme);
                // Show html on browser.
            } else {
                // Error: Pattern template not found.
            }
        } else {
            // Error: Them not found
        }
    } else {
        // Error: Layout not found
    }
}
if (true === DEBUG) {
    Pf::database()->show_debug_console();
}
